<?php 
ob_start();
session_start();

define('PATH','http://localhost/radhikatea/');
// define('PATH','http://localhost/foodbesties/');

define('WPATH',PATH.'neoadmin/');

define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASSWORD', '');
define('DB_NAME', 'radhikatea');


define('TIMES',date('Y-m-d H:i:s'));
define('PAGE_TITLE',"neoCRM");
define('VIEW','../');
define('THEME', 'theme');
define('THEME_MENU', 'theme_menu');

define('U_PATH', '../../uploads');
define('UPLOADURL',PATH.'stocks/');

//cookie
define('USERC', 'fbuser');
define('USERCT', 'fbusert');
define('USERT', 'myJWT');
define('LOC', 'myJWTlocation');
define('LOGIN_C', 'fbmad');


if (isset($_COOKIE[LOGIN_C]) && !empty($_COOKIE[LOGIN_C])) {
	define('ADMIN', $_COOKIE[LOGIN_C]);	
}

$user=NULL;
if (isset($_COOKIE[USERC]) && !empty($_COOKIE[USERC])) {
	$user=$_COOKIE[USERC];	
}
define('USER',$user);



class cpClass{
	
	public $db;
	public $where='';
	public $values='*';
	public $table;

	public function __construct()
	{
		try {
		  $this->db = new PDO("mysql:host=".DB_HOST.";dbname=".DB_NAME.';charset=utf8mb4', DB_USER, DB_PASSWORD, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
		  // set the PDO error mode to exception
		  $this->db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		  return "Connected successfully";
		} catch(PDOException $e) {
		  return "Connection failed: " . $e->getMessage();
		}
	}

	public function isWithinDistance(
	    float $lat1,
	    float $lon1,
	    float $lat2,
	    float $lon2,
	    float $maxDistanceMeters = 200
	): bool {
	    $earthRadius = 6371000; // Earth radius in meters

	    // Convert degrees to radians
	    $lat1 = deg2rad($lat1);
	    $lon1 = deg2rad($lon1);
	    $lat2 = deg2rad($lat2);
	    $lon2 = deg2rad($lon2);

	    // Differences
	    $dLat = $lat2 - $lat1;
	    $dLon = $lon2 - $lon1;

	    // Haversine formula
	    $a = sin($dLat / 2) * sin($dLat / 2) +
	         cos($lat1) * cos($lat2) *
	         sin($dLon / 2) * sin($dLon / 2);

	    $c = 2 * atan2(sqrt($a), sqrt(1 - $a));

	    $distance = $earthRadius * $c;

	    return $distance <= $maxDistanceMeters;
	}


	public function checkpara($array=[]){
		$total=count($array);
		$access=0;
		foreach ($array as $value) {
			if (isset($_REQUEST[$value]) && !empty($_REQUEST[$value])) {
				$access++;
			}
		}
		return $access;
		if ($access==$total) {
			return true;
		}else{
			return false;
		}
	}

	public function checkparabody($array=[],$param=[]){
		$total=count($array);
		$access=0;
		foreach ($array as $value) {
			if (isset($param[$value]) && !empty($param[$value])) {
				$access++;
			}
		}
		
		if ($access==$total) {
			return true;
		}else{
			return false;
		}
	}

	public function checkfilepara($array=[]){
		$total=count($array);
		$access=0;
		foreach ($array as $value) {
			if (isset($_FILES[$value]) && $_FILES[$value]['size']>0) {
				$access++;
			}
		}

		if ($access==$total) {
			return true;
		}else{
			return false;
		}
	}
	
	public function uuid() {
        $serverId = 'server-radhikatea'; // Unique identifier for the space
        $timestamp = microtime(true); // Current timestamp
        $random = mt_rand(0, 0xffff); // Random component
    
        return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
            $serverId,
            $timestamp,
            $random,
            mt_rand(0, 0x0fff) | 0x4000,
            mt_rand(0, 0x3fff) | 0x8000,
            mt_rand(0, 0xffff),
            mt_rand(0, 0xffff),
            mt_rand(0, 0xffff)
        );
    }

    public function getAuthorizationHeader(){
    	$headers = null;
	    if (isset($_SERVER['Authorization'])) {
	        $headers = trim($_SERVER["Authorization"]);
	    }
	    else if (isset($_SERVER['HTTP_AUTHORIZATION'])) { //Nginx or fast CGI
	        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
	    } elseif (function_exists('apache_request_headers')) {
	        $requestHeaders = apache_request_headers();
	        // Server-side fix for bug in old Android versions (a nice side-effect of this fix means we don't care about capitalization for Authorization)
	        $requestHeaders = array_combine(array_map('ucwords', array_keys($requestHeaders)), array_values($requestHeaders));
	        //print_r($requestHeaders);
	        if (isset($requestHeaders['Authorization'])) {
	            $headers = trim($requestHeaders['Authorization']);
	        }
	    }
	    return $headers;
	}

	public function getBearerToken() {
	    $headers = $this->getAuthorizationHeader();
	    error_log('Raw headers: ' . print_r(apache_request_headers() ?: $_SERVER, true)); // Log all headers
        error_log('Extracted auth header: ' . ($headers ?? 'null'));
	    // HEADER: Get the access token from the header
	    if (!empty($headers)) {
	        if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
	            return $matches[1];
	        }
	    }
	    return null;
	}
	
	// Function to convert emoji to Unicode
    public function emojiToUnicode($text) {
        return json_encode($text, JSON_UNESCAPED_UNICODE);
    }
    
    // Function to convert Unicode back to emoji
    public function unicodeToEmoji($text) {
        return json_decode($text);
    }


	public function chklogin($com=0){
		if (isset($_COOKIE[USERC]) && !empty($_COOKIE[USERC])) {
			if ($com==1) {
				header('Location: '.PATH);
			}
		}else{
			setcookie(USERC,md5(time().mt_rand(111111,999999)),time()+(84600*30),"/");
			setcookie(USERCT,md5(2),time()+(84600*30),"/");
		}
	}

	public function pcvalue($type,$id){
		$a='<div class="col-12">
            <label>'.$this->cname($id).'</label>';
        if ($type==1) {
        	$a.='<input type="text" class="form-control" name="'.$id.'" value="'.$this->cvalues($id).'">';	
        }else{
        	$a.='<textarea class="form-control" rows="3" name="'.$id.'">'.$this->cvalues($id).'</textarea>';
        }
        $a.='</div>';

        return $a;
	}

	public function clean_text($text){
		$text=trim($text);
		$text=stripslashes($text);
		$text=htmlspecialchars($text);
		return $text;
	}

	public function lastId(){
		return $this->db->lastInsertId(); 
	}

	public function urlslug(){
		return '<span>(To Know More About URL Slug <a href="https://premchauhan.com/blog/How-to-Create-the-Best-URL-Slugs-for-SEO" target="_blank">Click Here</a>)</span>';
	}

	public function star(){
		return '<span class="text text-danger">*</span>';
	}

	public function maincvalues($id){
		$fetch=$this->select('mainsetting')->where("id='$id'")->last();
		return $fetch->data;
	}

	public function cvalues($id){
		$fetch=$this->select('csetting')->where("id='$id'")->last();
		return $fetch->value;
	}

	public function cname($id){
		$fetch=$this->select('csetting')->where("id='$id'")->last();
		return $fetch->name;
	}

	public function conver_string($action,$string){
		$output='';
		$encrypt_method='AES-256-CBC';
		$secrateKey='';
		$secrate_iv='';
		$key=hash('sha256',$secrateKey);
		$initialization_vector=substr(hash('sha256',$secrate_iv), 0,16);
		if ($string!='') {
			if ($action=='enc') {
				$output=openssl_encrypt($string, $encrypt_method, $key,0,$initialization_vector);
				$output=base64_encode($output);
			}
			if ($action=='dec') {
				$output=base64_decode($output);
				$output=openssl_decrypt($output, $encrypt_method, $key,0,$initialization_vector);
			}
		}
		return $output;
	}

	public function destroy()
	{
		$this->db=null;
	}

	public function success($page,$msg='',$para='')
	{
	    if ($msg!='') {
	        echo '<script>alert("'.$msg.'");window.location.href="home/'.$page.$para.'"</script>';    
	        // echo '<script>window.location.href="home/'.$page.$para.'"</script>';    
	    }
	    else
	    {
	        echo '<script>window.location.href="home/'.$page.$para.'"</script>';
	        // echo '<script>alert("Saved Successfully");window.location.href="home/'.$page.$para.'"</script>';
	    }
	    
	}

	public function fail($page,$msg='',$para='')
	{

	    if ($msg!='') {
	       // echo '<script>window.location.href="home/'.$page.$para.'"</script>';    
	        echo '<script>alert("'.$msg.'"); window.location.href="home/'.$page.$para.'"</script>';    
	    }
	    else
	    {
	        echo '<script>window.location.href="home/'.$page.$para.'"</script>';
	        // echo '<script>alert("Saving Data Fail");window.location.href="home/'.$page.$para.'"</script>';
	        
	    }   
	}

	public function insert($table,$data)
	{
		$columns = "";
        $values = "";
        foreach ($data as $column => $value) {
            if($value!=''){
                $value=addslashes($value);
                $columns .= ($columns == "") ? "" : ", ";
                $columns .= $column;
                $values .= ($values == "") ? "" : ", ";
                $values .= "'".$value."'";   
            }
        }
        $sql = "insert into $table ($columns) values ($values)";
        $this->db->query($sql);
        return $this->db->lastInsertId(); 
	}

	function update($table,$data,$where)
	{
	    $values="";
	    foreach ($data as $key => $value) {
	        if($value!=''){
	            $values .= ($values == "") ? "" : ", ";
	            $values .= $key."="."'".addslashes($value)."'";   
	        }
	        
	        if($value==null){
	            $values .= ($values == "") ? "" : ", ";
	            $values .= $key."="."null";   
	        }
	    }

	    $sql="UPDATE $table SET $values WHERE $where";
	    if ($this->db->query($sql)) {
	        return true;
	    }
	    else
	    {
	        return false;
	    }
	}

	function delete_row($tbl,$id,$col='',$where=''){

		if ($col=='') {
			$col='id';
		}

		$f=$this->db->prepare("DELETE FROM $tbl WHERE $col=?".$where);
	    if($f->execute([$id]))
	    {
	        return 1;
	    }
	    else
	    {
	        return 0;
	    }
	}

	function delete_rows($tbl,$where=''){


		$f=$this->db->prepare("DELETE FROM $tbl WHERE ".$where);
	    if($f->execute())
	    {
	        return 1;
	    }
	    else
	    {
	        return 0;
	    }
	}

	function select($tbl)
	{
		// $this->values='';
		// return array($tbl,$this->where,$this->values);
		$this->where='';
		// $this->values='';
		$this->table=$tbl;
		return $this;
	}

	function where($where='')
	{
		$this->where=$where;
		return $this;
	}

	function data($data=array())
	{
		if (count($data)>0) {
			$this->values='';
	        foreach ($data as $key => $value) {
		        $this->values .= ($this->values == "") ? "" : ", ";
		        $this->values .= $value;
	        }    
	        
	    }else{
	    	$this->values='*';
	    }
	    return $this;
	}

	function first($col=''){

		if ($col=='') {
			$col='id';
		}

		if ($this->where=='') {
			$this->where='1=1 ORDER BY '.$col.' ASC LIMIT 1';
		}else{
			$this->where.=' ORDER BY '.$col.' ASC LIMIT 1';
		}

		return $this->select_row($this->table,$this->where,$this->values);
	}

	function last($col=''){

		if ($col=='') {
			$col='id';
		}

		if ($this->where=='') {
			$this->where='1=1 ORDER BY '.$col.' DESC LIMIT 1';
		}else{
			$this->where.=' ORDER BY '.$col.' DESC LIMIT 1';
		}

		return $this->select_row($this->table,$this->where,$this->values);
	}

	function all(){
		return $this->select_rows($this->table,$this->where,$this->values);	
	}

	function count(){
		return count($this->select_rows($this->table,$this->where,$this->values));
	}

	function select_row($table,$where='',$data='')
	{
	    $sql="SELECT $data FROM $table";
	    if ($where!="") {
	    	// $where=str_replace('\'','"', $where);
	        $sql.=" WHERE $where";
	    }
	    $a=$this->db->query($sql);
	    $a=$a->fetch(PDO::FETCH_OBJ);
	    return $a;
	    // return $sql;
	}

	function select_rows($table,$where='',$data='')
	{
	    $sql="SELECT $data FROM $table";
	    
	    if ($where!="" && !empty($where)) {
	        $sql.=" WHERE $where";
	    }
	    $a=$this->db->query($sql);
	    $a=$a->fetchAll(PDO::FETCH_OBJ);
	    return $a;
	}

	function get_ip() {
	    $ipaddress = '';
	    if (isset($_SERVER['HTTP_CLIENT_IP']))
	        $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
	    else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
	        $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
	    else if(isset($_SERVER['HTTP_X_FORWARDED']))
	        $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
	    else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
	        $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
	    else if(isset($_SERVER['HTTP_FORWARDED']))
	        $ipaddress = $_SERVER['HTTP_FORWARDED'];
	    else if(isset($_SERVER['REMOTE_ADDR']))
	        $ipaddress = $_SERVER['REMOTE_ADDR'];
	    else
	        $ipaddress = 'UNKNOWN';
	    return $ipaddress;
	}

	public function print_alert($msg)
	{
		echo "<script>alert('".$msg."')</script>";exit;
	}

	public function redirect($path,$msg='')
    {
    	if ($msg!='') {
    		echo '<script>alert("'.$msg.'");window.location="'.$path.'";</script>';	
    	}else{
    		echo "<script>window.location='".$path."';</script>";
    	}
        
    }

    function random_str($length)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $randomString = '';
        for ($i = 0; $i < $length; $i++)
        {
            $randomString .= $characters[rand(0, strlen($characters) - 1)];
        }
        return $randomString;
    }
	
	function random_number($digits)
    {
        return rand(pow(10, $digits-1), pow(10, $digits)-1);
    }


	function store_uploaded_image_webp($html_element_name, $new_img_width=0, $new_img_height=0) {
    
	    $target_dir = U_PATH."/";
	    $ext =explode(".", $_FILES[$html_element_name]["name"]);
	    $ext = end($ext);
	    $tmpfile=mt_rand(11111111,99999999);
	    $filename=$tmpfile.'.'.$ext;
	    $filename=str_replace(' ', '_',$filename);
	    $target_file = $target_dir . $filename;
	    
	    if (($_FILES[$html_element_name]["type"] == "image/jpg") || ($_FILES[$html_element_name]["type"] == "image/jpeg")) {
	    	$image = new SimpleImage();
		    $image->load($_FILES[$html_element_name]['tmp_name']);
		    // $image->rotate('p');
		    if ($new_img_width!=0 && $new_img_height!=0) {
		        $image->resize($new_img_width, $new_img_height);    
		    }
		    $image->save($target_file);
		    $image->save_webp($target_file,$tmpfile);
		    return $tmpfile.'.webp'; //return name of saved file in case you want to store it in you database or show confirmation message to user	
	    }else{
	    	$move_uploaded_file= move_uploaded_file($_FILES[$html_element_name]['tmp_name'],$target_dir.$filename);
			if($move_uploaded_file)
			{
				return $filename;
			}
	    }
	}

	function store_uploaded_image_webp_test($html_element_name, $new_img_width=0, $new_img_height=0) {
    
	    $target_dir = U_PATH."/";
	    $ext =explode(".", $_FILES[$html_element_name]["name"]);
	    $ext = end($ext);
	    $tmpfile=mt_rand(11111111,99999999);
	    $filename=$tmpfile.'.'.$ext;
	    $filename=str_replace(' ', '_',$filename);
	    $target_file = $target_dir . $filename;
	    
	    if (($_FILES[$html_element_name]["type"] == "image/jpg") || ($_FILES[$html_element_name]["type"] == "image/jpeg")) {
	    	$image = new SimpleImage();
		    $image->load($_FILES[$html_element_name]['tmp_name']);
		    $image->scale(50);
		    if ($new_img_width!=0 && $new_img_height!=0) {
		        $image->resize($new_img_width, $new_img_height);    
		    }
		    $image->save($target_file);
		    $image->save_webp($target_file,$tmpfile);
		    return $tmpfile.'.webp'; //return name of saved file in case you want to store it in you database or show confirmation message to user	
	    }else{
	    	$move_uploaded_file= move_uploaded_file($_FILES[$html_element_name]['tmp_name'],$target_dir.$filename);
			if($move_uploaded_file)
			{
				return $filename;
			}
	    }
	}

	function store_uploaded_image_webp_api($html_element_name, $new_img_width=0, $new_img_height=0) {
    
	    $target_dir = "../neoadmin/uploads/";
	    $ext =explode(".", $_FILES[$html_element_name]["name"]);
	    $ext = end($ext);
	    $tmpfile=mt_rand(11111111,99999999);
	    $filename=$tmpfile.'.'.$ext;
	    $filename=str_replace(' ', '_',$filename);
	    $target_file = $target_dir . $filename;
	    
	    if (($_FILES[$html_element_name]["type"] == "image/jpg") || ($_FILES[$html_element_name]["type"] == "image/jpeg")) {
	    	$image = new SimpleImage();
		    $image->load($_FILES[$html_element_name]['tmp_name']);
		    // $image->rotate('p');
		    if ($new_img_width!=0 && $new_img_height!=0) {
		        $image->resize($new_img_width, $new_img_height);    
		    }
		    $image->save($target_file);
		    $image->save_webp($target_file,$tmpfile);
		    return $tmpfile.'.webp'; //return name of saved file in case you want to store it in you database or show confirmation message to user	
	    }else{
	    	$move_uploaded_file= move_uploaded_file($_FILES[$html_element_name]['tmp_name'],$target_dir.$filename);
			if($move_uploaded_file)
			{
				return $filename;
			}
	    }
	}

	function store_uploaded_image_webp_multi($html_element_name,$key, $new_img_width=0, $new_img_height=0) {
    
		$target_dir = U_PATH."/";
	    $ext =explode(".", $_FILES[$html_element_name]["name"][$key]);
	    $ext = end($ext);
	    $tmpfile=mt_rand(11111111,99999999);
	    $filename=$tmpfile.'.'.$ext;
	    $filename=str_replace(' ', '_',$filename);
	    $target_file = $target_dir . $filename;
	    
	    if (($_FILES[$html_element_name]["type"][$key] == "image/jpg") || ($_FILES[$html_element_name]["type"][$key] == "image/jpeg")) {
	    	$image = new SimpleImage();
		    $image->load($_FILES[$html_element_name]['tmp_name'][$key]);
		    // $image->rotate('p');
		    if ($new_img_width!=0 && $new_img_height!=0) {
		        $image->resize($new_img_width, $new_img_height);    
		    }
		    $image->save($target_file);
		    $image->save_webp($target_file,$tmpfile);
		    return $tmpfile.'.webp'; //return name of saved file in case you want to store it in you database or show confirmation message to user	
	    }else{
	    	$move_uploaded_file= move_uploaded_file($_FILES[$html_element_name]['tmp_name'][$key],$target_dir.$filename);
			if($move_uploaded_file)
			{
				return $filename;
			}
	    }
	}


}

class resize
		{
			// *** Class variables
			private $image;
		    private $width;
		    private $height;
			private $imageResized;

			function __construct($fileName)
			{
				// *** Open up the file
				$this->image = $this->openImage($fileName);

			    // *** Get width and height
			    $this->width  = imagesx($this->image);
			    $this->height = imagesy($this->image);
			}

			## --------------------------------------------------------

			private function openImage($file)
			{
				// *** Get extension
				$extension = strtolower(strrchr($file, '.'));

				switch($extension)
				{
					case '.jpg':
					case '.jpeg':
						$img = @imagecreatefromjpeg($file);
						break;
					case '.gif':
						$img = @imagecreatefromgif($file);
						break;
					case '.png':
						$img = @imagecreatefrompng($file);
						break;
					default:
						$img = false;
						break;
				}
				return $img;
			}

			## --------------------------------------------------------

			public function resizeImage($newWidth, $newHeight, $option="auto")
			{
				// *** Get optimal width and height - based on $option
				$optionArray = $this->getDimensions($newWidth, $newHeight, $option);

				$optimalWidth  = $optionArray['optimalWidth'];
				$optimalHeight = $optionArray['optimalHeight'];

				// *** Resample - create image canvas of x, y size
				$this->imageResized = imagecreatetruecolor($optimalWidth, $optimalHeight);

				//Default is white backgroud
				$backgroundColor = imagecolorallocate($this->imageResized, 255, 255, 255);
				imagefill($this->imageResized, 0, 0, $backgroundColor);

				//This Code for tranferant image
				/*imagealphablending($this->imageResized,true);
				imagesavealpha($this->imageResized,true);*/

				imagecopyresampled($this->imageResized, $this->image, 0, 0, 0, 0, $optimalWidth, $optimalHeight, $this->width, $this->height);

				// *** if option is 'crop', then crop too
				if ($option == 'crop') {
					$this->crop($optimalWidth, $optimalHeight, $newWidth, $newHeight);
				}
			}

			## --------------------------------------------------------
			
			private function getDimensions($newWidth, $newHeight, $option)
			{

			   switch ($option)
				{
					case 'exact':
						$optimalWidth = $newWidth;
						$optimalHeight= $newHeight;
						break;
					case 'portrait':
						$optimalWidth = $this->getSizeByFixedHeight($newHeight);
						$optimalHeight= $newHeight;
						break;
					case 'landscape':
						$optimalWidth = $newWidth;
						$optimalHeight= $this->getSizeByFixedWidth($newWidth);
						break;
					case 'auto':
						$optionArray = $this->getSizeByAuto($newWidth, $newHeight);
						$optimalWidth = $optionArray['optimalWidth'];
						$optimalHeight = $optionArray['optimalHeight'];
						break;
					case 'crop':
						$optionArray = $this->getOptimalCrop($newWidth, $newHeight);
						$optimalWidth = $optionArray['optimalWidth'];
						$optimalHeight = $optionArray['optimalHeight'];
						break;
				}
				return array('optimalWidth' => $optimalWidth, 'optimalHeight' => $optimalHeight);
			}

			## --------------------------------------------------------

			private function getSizeByFixedHeight($newHeight)
			{
				$ratio = $this->width / $this->height;
				$newWidth = $newHeight * $ratio;
				return $newWidth;
			}

			private function getSizeByFixedWidth($newWidth)
			{
				$ratio = $this->height / $this->width;
				$newHeight = $newWidth * $ratio;
				return $newHeight;
			}

			private function getSizeByAuto($newWidth, $newHeight)
			{
				if ($this->height < $this->width)
				// *** Image to be resized is wider (landscape)
				{
					$optimalWidth = $newWidth;
					$optimalHeight= $this->getSizeByFixedWidth($newWidth);
				}
				elseif ($this->height > $this->width)
				// *** Image to be resized is taller (portrait)
				{
					$optimalWidth = $this->getSizeByFixedHeight($newHeight);
					$optimalHeight= $newHeight;
				}
				else
				// *** Image to be resizerd is a square
				{
					if ($newHeight < $newWidth) {
						$optimalWidth = $newWidth;
						$optimalHeight= $this->getSizeByFixedWidth($newWidth);
					} else if ($newHeight > $newWidth) {
						$optimalWidth = $this->getSizeByFixedHeight($newHeight);
						$optimalHeight= $newHeight;
					} else {
						// *** Sqaure being resized to a square
						$optimalWidth = $newWidth;
						$optimalHeight= $newHeight;
					}
				}

				return array('optimalWidth' => $optimalWidth, 'optimalHeight' => $optimalHeight);
			}

			## --------------------------------------------------------

			private function getOptimalCrop($newWidth, $newHeight)
			{

				$heightRatio = $this->height / $newHeight;
				$widthRatio  = $this->width /  $newWidth;

				if ($heightRatio < $widthRatio) {
					$optimalRatio = $heightRatio;
				} else {
					$optimalRatio = $widthRatio;
				}

				$optimalHeight = $this->height / $optimalRatio;
				$optimalWidth  = $this->width  / $optimalRatio;

				return array('optimalWidth' => $optimalWidth, 'optimalHeight' => $optimalHeight);
			}

			## --------------------------------------------------------

			private function crop($optimalWidth, $optimalHeight, $newWidth, $newHeight)
			{
				// *** Find center - this will be used for the crop
				$cropStartX = ( $optimalWidth / 2) - ( $newWidth /2 );
				$cropStartY = ( $optimalHeight/ 2) - ( $newHeight/2 );

				$crop = $this->imageResized;
				//imagedestroy($this->imageResized);

				// *** Now crop from center to exact requested size
				$this->imageResized = imagecreatetruecolor($newWidth , $newHeight);				
				imagecopyresampled($this->imageResized, $crop , 0, 0, $cropStartX, $cropStartY, $newWidth, $newHeight , $newWidth, $newHeight);
			}

			## --------------------------------------------------------

			public function saveImage($savePath, $imageQuality="100")
			{
				// *** Get extension
        		$extension = strrchr($savePath, '.');
       			$extension = strtolower($extension);

				switch($extension)
				{
					case '.jpg':
					case '.jpeg':
						if (imagetypes() & IMG_JPG) {
							imagejpeg($this->imageResized,$savePath,$imageQuality);
						}
						break;

					case '.gif':
						if (imagetypes() & IMG_GIF) {
							imagegif($this->imageResized, $savePath);
						}
						break;

					case '.png':
						// *** Scale quality from 0-100 to 0-9
						$scaleQuality = round(($imageQuality/100) * 9);

						// *** Invert quality setting as 0 is best, not 9
						$invertScaleQuality = 9 - $scaleQuality;

						if (imagetypes() & IMG_PNG) {
							 imagepng($this->imageResized, $savePath, $invertScaleQuality);
						}
						break;

					// ... etc

					default:
						// *** No extension - No save.
						break;
				}

				imagedestroy($this->imageResized);
			}


			## --------------------------------------------------------

		}

class SimpleImage {
 
   var $image;
   var $image_type;

   function returnt()
   {
   		return $this->image_type;
   }
 
   function load($filename) {

      $image_info = getimagesize($filename);
      
      $this->image_type = $image_info[2];
      if( $this->image_type == IMAGETYPE_JPEG || $this->image_type == '2') {
         $this->image = imagecreatefromjpeg($filename);
      } elseif( $this->image_type == IMAGETYPE_GIF ) {
 
         $this->image = imagecreatefromgif($filename);
      } elseif( $this->image_type == IMAGETYPE_PNG  || $this->image_type == '3') {
 
         $this->image = imagecreatefrompng($filename);
      }
   }

   function rotate($o)
   {
      //--------------
      if ($o=='l') {
         if ($this->image_info[0] < $this->image_info[1]) {
            $this->image =imagerotate($this->image, 90, 0);   
         }   
      }
      //|||||||||||||
      else if ($o=='p') {
         if ($this->image_info[0] > $this->image_info[1]) {
            $this->image =imagerotate($this->image, 90, 0);   
         }
      }
      else
      {}
   }


   function save($filename, $image_type=IMAGETYPE_JPEG, $compression=100, $permissions=null) {
 
      if( $image_type == IMAGETYPE_JPEG  || $this->image_type == '2') {
         imagejpeg($this->image,$filename,$compression);
      } elseif( $image_type == IMAGETYPE_GIF ) {
 
         imagegif($this->image,$filename);
      } elseif( $image_type == IMAGETYPE_PNG  || $this->image_type == '3') {
 
         imagepng($this->image,$filename);
      } elseif( $image_type == IMAGETYPE_AVIF  || $this->image_type == '4') {
         imageavif($this->image,$filename);
      }

      if( $permissions != null) {
         chmod($filename,$permissions);
      }
   }

   function save_webp($filename,$tmpname)
   {
   	  $target_dir = U_PATH."/";
   	  $img='';
      if( $this->image_type == IMAGETYPE_JPEG  || $this->image_type == '2') {
      	$img = imagecreatefromjpeg($filename);
      }elseif( $this->image_type == IMAGETYPE_PNG  || $this->image_type == '3') {
      	$img = imagecreatefrompng($filename);
      } 
      // imageavif($img,'11.avif');
      imagewebp($img,$target_dir.$tmpname.'.webp', 90);

      unlink($filename);
   }

   function output($image_type=IMAGETYPE_JPEG) {
 
      if( $image_type == IMAGETYPE_JPEG ) {
         imagejpeg($this->image);
      } elseif( $image_type == IMAGETYPE_GIF ) {
 
         imagegif($this->image);
      } elseif( $image_type == IMAGETYPE_PNG ) {
 
         imagepng($this->image);
      }
   }
   function getWidth() {
      return imagesx($this->image);
   }
   function getHeight() {
 
      return imagesy($this->image);
   }
   function resizeToHeight($height) {
 
      $ratio = $height / $this->getHeight();
      $width = $this->getWidth() * $ratio;
      $this->resize($width,$height);
   }
 
   function resizeToWidth($width) {
      $ratio = $width / $this->getWidth();
      $height = $this->getheight() * $ratio;
      $this->resize($width,$height);
   }
 
   function scale($scale) {
      $width = $this->getWidth() * $scale/100;
      $height = $this->getheight() * $scale/100;
      $this->resize($width,$height);
   }

   function wm_image($path)
   {
      $watermarkImg = imagecreatefrompng($path); 

      $marge_right = 10; 
      $marge_bottom = 10; 

      $sx = imagesx($watermarkImg); 
      $sy = imagesy($watermarkImg); 

      imagecopy($this->image, $watermarkImg, imagesx($this->image) - $sx - $marge_right, imagesy($this->image) - $sy - $marge_bottom, 0, 0, imagesx($watermarkImg), imagesy($watermarkImg)); 
   }

   function wm_text($text)
   {
      $textcolor = imagecolorallocate($this->image, 0, 0, 0);
  
      $font_file = 'C:\xampp\htdocs\demo\imgdemo\uploads\times.ttf';
        
      $custom_text = $text;
        
      imagettftext($this->image, 10, 0, 10, 20, $textcolor, $font_file, $custom_text);
   }
 
   function resize($width,$height) {

      $new_image = imagecreatetruecolor($width, $height);
      imagecopyresampled($new_image, $this->image, 0, 0, 0, 0, $width, $height, $this->getWidth(), $this->getHeight());
      $this->image = $new_image;
      
   }      
 
}


?>